// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     device/devices_app/usb/public/interfaces/device.mojom
//

package org.chromium.mojom.device.usb;

public final class EndpointInfo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 24;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public byte endpointNumber;
    public int direction;
    public int type;
    public int packetSize;

    private EndpointInfo(int version) {
        super(STRUCT_SIZE, version);
    }

    public EndpointInfo() {
        this(0);
    }

    public static EndpointInfo deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static EndpointInfo decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        EndpointInfo result = new EndpointInfo(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.endpointNumber = decoder0.readByte(8);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.direction = decoder0.readInt(12);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.type = decoder0.readInt(16);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.packetSize = decoder0.readInt(20);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(endpointNumber, 8);
        encoder0.encode(direction, 12);
        encoder0.encode(type, 16);
        encoder0.encode(packetSize, 20);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        EndpointInfo other = (EndpointInfo) object;
        if (this.endpointNumber != other.endpointNumber)
            return false;
        if (this.direction != other.direction)
            return false;
        if (this.type != other.type)
            return false;
        if (this.packetSize != other.packetSize)
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(endpointNumber);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(direction);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(type);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(packetSize);
        return result;
    }
}

